package com.shifterwebapp.shifter.coursecontent;

import com.shifterwebapp.shifter.course.Course;
import jakarta.persistence.*;
import com.shifterwebapp.shifter.coursecontent.enums.ContentType;
import lombok.*;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Entity
public class CourseContent {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "course_seq")
    @SequenceGenerator(name = "course_seq", sequenceName = "course_sequence", allocationSize = 1)
    private Long id;

    private String title;

    private Integer position;

    private String contentURL;

    private ContentType contentType;

    @ManyToOne
    @JoinColumn(name = "course_id")
    private Course course;
}

