package com.shifterwebapp.shifter.enrollment;

import com.shifterwebapp.shifter.course.Course;
import com.shifterwebapp.shifter.enrollment.enums.EnrollmentStatus;
import com.shifterwebapp.shifter.payment.Payment;
import com.shifterwebapp.shifter.review.Review;
import jakarta.persistence.*;
import lombok.*;

import java.util.Date;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Entity
public class Enrollment {
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "enrollment_seq")
    @SequenceGenerator(name = "enrollment_seq", sequenceName = "enrollment_sequence", allocationSize = 1)
    private Long id;

    private EnrollmentStatus enrollmentStatus;

    private Integer percentCompleted;

    private Date date;

    @OneToOne
    @JoinColumn(name = "payment_id")
    private Payment payment;

    @OneToOne(mappedBy = "enrollment", cascade = CascadeType.ALL, orphanRemoval = true)
    private Review review;

    @ManyToOne
    @JoinColumn(name = "course_id")
    private Course course;
}

