package com.db.finki.www.build_board.entity.access_managment;

import com.db.finki.www.build_board.common.enums.ProjectResourcePermissionOverrideType;
import com.db.finki.www.build_board.entity.compositeId.ProjectRolePermissionId;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Table(name = "role_permissions")
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
public class ProjectRolePermission {
    @EmbeddedId
    private ProjectRolePermissionId id;

    @Column(name = "override_type",nullable = false)
    private String overrideType;

    public Permission getPermission() {
        return id.getPermission();
    }

    public ProjectRole getProjectRole() {
        return id.getProjectRole();
    }
    public ProjectResourcePermissionOverrideType getOverrideType() {
        return overrideType.equals(ProjectResourcePermissionOverrideType.INCLUDE.name()) ?
                ProjectResourcePermissionOverrideType.INCLUDE
                : ProjectResourcePermissionOverrideType.EXCLUDE;
    }

}
