import { Formik, Field, Form, ErrorMessage } from "formik";
import * as Yup from "yup";
import { Button, Text, Flex } from "@chakra-ui/react";

const SignupSchema = Yup.object().shape({
    vin: Yup.string()
        .required("This field is required!")
        .min(5, "VINs are longer")
        .max(20, "VINs are shorter"),
    car_body: Yup.string().required("This field is required!"),
    car_make: Yup.string().required("This field is required!"),
    car_model: Yup.string().required("This field is required!"),
    p_year: Yup.string()
        .required("This field is required!")
        .min(4, "Invaild Year.")
        .max(4, "Invalid Year")
        .matches(/^[0-9]*$/, "Must be a number."),
    capacity: Yup.string().required("This field is required!"),
    power: Yup.string().required("This field is required!"),
    color: Yup.string().required("This field is required!"),
    price: Yup.string()
        .required("This field is required!")
        .min(4, "Invalid Price")
        .max(6, "Invalid Price")
        .matches(/^[0-9]*$/, "Must be a number."),
});

const AddVehicle = () => {
    const createVehicle = ({
        vin,
        car_body,
        car_make,
        car_model,
        p_year,
        capacity,
        power,
        color,
        price,
        tax_nr
    }) => {
        fetch("http://localhost:3001/createvehicle", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({
                vin,
                car_body,
                car_make,
                car_model,
                p_year,
                capacity,
                power,
                color,
                price,
                tax_nr,
            }),
        }).then((response) => {
            return response.text();
        });
    };

    return (
        <>
            <Text marginBottom='50px' fontWeight='bold' fontSize='32px'>
                Add new vehicle listing
            </Text>
            <Formik
                initialValues={{
                    vin: "",
                    car_body: "",
                    car_make: "",
                    car_model: "",
                    p_year: "",
                    capacity: "",
                    power: "",
                    color: "",
                    price: "",
                    tax_nr: "BM15153"
                }}
                validationSchema={SignupSchema}
                onSubmit={async (values) => {
                    createVehicle(values);
                    alert("Successfully entered car!");
                }}>
                {({ isSubmitting, errors, touched }) => (
                    <Form width='100%'>
                        <Flex
                            boxShadow='lg'
                            hover={{ boxShadow: "xl" }}
                            borderBottomRadius='10px'
                            bg='white'
                            borderRadius='13px'
                            transition='all 0.4s ease'
                            direction='column'
                            padding='20px'
                            width='100%'>
                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='vin'>
                                        VIN
                                    </label>
                                    <Field
                                        name='vin'
                                        placeholder='WUZZ1255643'
                                    />
                                </Flex>
                                {errors.vin && touched.vin ? (
                                    <Flex>{errors.vin}</Flex>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='car_body'>
                                        Body Type
                                    </label>
                                    <Field
                                        name='car_body'
                                        placeholder='Car'
                                        as='select'>
                                        <option value='Car'>Car</option>
                                        <option value='Motorcycle'>
                                            Motorcycle
                                        </option>
                                        <option value='Truck'>Truck</option>
                                        <option value='Van'>Van</option>
                                    </Field>
                                </Flex>
                                {errors.car_body && touched.car_body ? (
                                    <div>{errors.car_body}</div>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='car_make'>
                                        Car Make
                                    </label>
                                    <Field
                                        name='car_make'
                                        placeholder='BMW'
                                        as='select'>
                                        <option value='BMW'>BMW</option>
                                        <option value='MINI'>
                                            MINI
                                        </option>
                                    </Field>
                                </Flex>
                                {errors.car_make && touched.car_make ? (
                                    <div>{errors.car_make}</div>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='car_model'>
                                        Model
                                    </label>
                                    <Field
                                        name='car_model'
                                        placeholder='G30 530d'
                                    />
                                </Flex>
                                {errors.car_model && touched.car_model ? (
                                    <div>{errors.car_model}</div>
                                ) : null}
                            </Flex>

                            

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='p_year'>
                                        Year
                                    </label>
                                    <Field name='p_year' placeholder='2017' />
                                </Flex>
                                {errors.p_year && touched.p_year ? (
                                    <Flex maxWidth='500px'>
                                        {errors.p_year}
                                    </Flex>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='capacity'>
                                        Capacity
                                    </label>
                                    <Field name='capacity' placeholder='3000cc' />
                                </Flex>
                                {errors.capacity && touched.capacity ? (
                                    <div>{errors.capacity}</div>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='power'>
                                        Power (kW)
                                    </label>
                                    <Field name='power' placeholder='150' />
                                </Flex>
                                {errors.power && touched.power ? (
                                    <div>{errors.power}</div>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='color'>
                                        Color
                                    </label>
                                    <Field name='color' as='select'>
                                        <option value='red'>Red</option>
                                        <option value='green'>Green</option>
                                        <option value='blue'>Blue</option>
                                        <option value='black'>Black</option>
                                        <option value='white'>White</option>
                                        <option value='yellow'>Yellow</option>
                                        <option value='orange'>Orange</option>
                                        <option value='purple'>Purple</option>
                                        <option value='silver'>Silver</option>
                                        <option value='grey'>Grey</option>
                                        <option value='cyan'>Cyan</option>
                                        <option value='magenta'>Magenta</option>
                                    </Field>
                                </Flex>
                                {errors.color && touched.color ? (
                                    <div>{errors.color}</div>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='price'>
                                        Price
                                    </label>
                                    <Field name='price' placeholder='35600' />
                                </Flex>
                                {errors.price && touched.price ? (
                                    <div>{errors.price}</div>
                                ) : null}
                            </Flex>

                            <Button
                                colorScheme='blue'
                                type='submit'
                                disabled={isSubmitting}>
                                Submit
                            </Button>
                        </Flex>
                    </Form>
                )}
            </Formik>
        </>
    );
};

export default AddVehicle;
