import { Formik, Field, Form, ErrorMessage } from "formik";
import * as Yup from "yup";
import { Button, Text, Flex } from "@chakra-ui/react";

const SignupSchema = Yup.object().shape({
    EMBG: Yup.string()
        .min(13, "Must be 13 digits exactly!")
        .max(13, "Must be 13 digits exactly!")
        .required("This field is required!")
        .matches(/^[0-9]*$/, "Must be a number."),
    C_name: Yup.string()
        .min(5, "Too Short!")
        .max(50, "Too Long!")
        .required("This field is required!"),

    Email: Yup.string()
        .email("Invalid email")
        .required("This field is required!"),
    Pass: Yup.string()
        .required("Must enter a password!")
        .min(8, "Must have 8 or more characters.")
        .matches(
            /^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{8,})/,
            "Must have one uppercase, one lowercase, one number and one special case character."
        ),
    Telephone: Yup.string()
        .min(9, "Phone number must be 9 digits exactly.")
        .max(9, "Phone number must be 9 digits exactly.")
        .matches(/^[0-9]*$/, "Must be a number."),
});

const RegisterForm = () => {
    const registerUser = ({ EMBG, C_name, Email, Pass, Telephone }) => {
        fetch("http://localhost:3001/registeruser", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({ EMBG, C_name, Email, Pass, Telephone }),
        }).then((response) => {
            return response.text();
        });
    };

    const sleep = (ms) => new Promise((r) => setTimeout(r, ms));

    return (
        <>
            <Text
                marginBottom='20px'
                textAlign='center'
                fontWeight='bold'
                fontSize='32px'
                justifySelf='center'>
                Register Form
            </Text>
            <Formik
                initialValues={{
                    EMBG: "",
                    C_name: "",
                    Email: "",
                    Pass: "",
                    Telephone: "",
                }}
                validationSchema={SignupSchema}
                onSubmit={async (values) => {
                    registerUser(values);
                    alert("Successfully created user!");
                }}>
                {({ isSubmitting, errors, touched }) => (
                    <Form width='100%'>
                        <Flex
                            boxShadow='lg'
                            hover={{ boxShadow: "xl" }}
                            borderBottomRadius='10px'
                            bg='white'
                            borderRadius='13px'
                            transition='all 0.4s ease'
                            direction='column'
                            padding='20px'
                            width='100%'>
                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='EMBG'>
                                        EMBG
                                    </label>
                                    <Field
                                        name='EMBG'
                                        placeholder='1507995410010'
                                    />
                                </Flex>
                                {errors.EMBG && touched.EMBG ? (
                                    <Flex>{errors.EMBG}</Flex>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='C_name'>
                                        Name
                                    </label>
                                    <Field
                                        name='C_name'
                                        placeholder='Jane Doe'
                                    />
                                </Flex>
                                {errors.C_name && touched.C_name ? (
                                    <div>{errors.C_name}</div>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='Email'>
                                        Email
                                    </label>
                                    <Field
                                        name='Email'
                                        placeholder='jane@acme.com'
                                        type='email'
                                    />
                                </Flex>
                                {errors.Email && touched.Email ? (
                                    <div>{errors.Email}</div>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='Pass'>
                                        Password
                                    </label>
                                    <Field
                                        name='Pass'
                                        placeholder='fDs@d87fsd'
                                    />
                                </Flex>
                                {errors.Pass && touched.Pass ? (
                                    <Flex maxWidth='500px'>{errors.Pass}</Flex>
                                ) : null}
                            </Flex>

                            <Flex padding='10px' direction='column'>
                                <Flex>
                                    <label
                                        style={{ marginRight: "15px" }}
                                        htmlFor='Telephone'>
                                        Telephone
                                    </label>
                                    <Field
                                        name='Telephone'
                                        placeholder='077461321'
                                    />
                                </Flex>
                                {errors.Telephone && touched.Telephone ? (
                                    <div>{errors.Telephone}</div>
                                ) : null}
                            </Flex>

                            <Button
                                colorScheme='blue'
                                type='submit'
                                disabled={isSubmitting}>
                                Submit
                            </Button>
                        </Flex>
                    </Form>
                )}
            </Formik>
        </>
    );
};

export default RegisterForm;
