import { Outlet, useLocation, useNavigate } from "react-router-dom";
import { Link, Button, Text, useToast } from '@chakra-ui/react'
import { Flex } from '@chakra-ui/react'
import { useState, useEffect } from 'react';

const Layout = () => {
  const [authState, setAuthState] = useState({ loggedIn: false, userType: null, userName: null });
  const toast = useToast();
  const location = useLocation();
  const navigate = useNavigate();

  useEffect(() => {
    checkAuthStatus();
  }, []);

  // Check auth status when route changes (e.g., after login)
  useEffect(() => {
    checkAuthStatus();
  }, [location.pathname]);

  const checkAuthStatus = async () => {
    try {
      const response = await fetch("http://localhost:3001/auth/status", {
        credentials: 'include'
      });
      const data = await response.json();
      console.log('Auth status check result:', data);
      setAuthState(data);
    } catch (error) {
      console.error('Error checking auth status:', error);
    }
  };

  const handleLogout = async () => {
    try {
      const response = await fetch("http://localhost:3001/logout", {
        method: "POST",
        credentials: 'include'
      });
      
      if (response.ok) {
        setAuthState({ loggedIn: false, userType: null, userName: null });
        toast({
          title: "Logged out",
          description: "You have been logged out successfully",
          status: "success",
          duration: 2000,
          isClosable: true,
        });
        // Redirect to home page after logout
        navigate("/");
      }
    } catch (error) {
      console.error('Error logging out:', error);
    }
  };

  return (
    <Flex direction='column' justify='center' align='center' alignSelf='center'>
      <Flex marginBottom="50px" borderBottom="4px"
		borderColor="teal" borderBottomRadius="8px" maxWidth='100%' direction='row' padding='10px'>
        <Flex fontSize="20px" direction='row' padding='5px' alignItems='center'>
            <Link padding='0px 20px' href="/">CarZone</Link>
          
            {authState.loggedIn && authState.userType === 'dealership' && (
              <>
                <Link padding='0px 20px' href="/mylist">My Vehicles</Link>
                <Link padding='0px 20px' href="/addvehicle">Add Vehicle</Link>
                <Link padding='0px 20px' href="/reports">Reports</Link>
              </>
            )}

            {authState.loggedIn && authState.userType === 'client' && (
              <Link padding='0px 20px' href="/myagreements">My Agreements</Link>
            )}

                        {!authState.loggedIn && (
              <>
                <Link padding='0px 20px' href="/login">Login</Link>
                <Link padding='0px 20px' href="/register">Register</Link>
            </>
            )}

            {authState.loggedIn && (
              <Flex alignItems='center' marginLeft='20px'>
                <Text fontSize='16px' marginRight='10px'>
                  Welcome, {authState.userName}
                </Text>
                <Button size='sm' colorScheme='red' onClick={handleLogout}>
                  Logout
                </Button>
              </Flex>
            )}
        </Flex>
      </Flex>
      <Outlet />
</Flex>
  )
};

export default Layout;
