package mk.ukim.finki.db.distributorapp.weekday;

import lombok.NonNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

public interface WeekdayRepository extends JpaRepository<Weekday, Short> {
    @Modifying
    @Transactional
    @Query(
            nativeQuery = true,
            value = "insert into weekday(day_id,day_name) " +
                    "values (?1,?2)"
    )
    Integer create(@NonNull String dayName);

    @Modifying
    @Transactional
    @Query(
            nativeQuery = true,
            value = "update weekday " +
                    "set day_name=?2 " +
                    "where day_id=?1"
    )
    Integer edit(@NonNull Short id, @NonNull String dayName);

    @Modifying
    @Transactional
    @Query(
            nativeQuery = true,
            value = "delete from weekday " +
                    "where day_id=?1"
    )
    void deleteById(@NonNull Short id);
}
