﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepo
{
    public class PHRepo : IPHRepo
    {
        private readonly FarmatikoDataContext _context;
        public PHRepo(FarmatikoDataContext context)
        {
            _context = context;
        }

        public async Task ClaimPharmacy(RequestPharmacyHead pharmacy)
        {
            await Task.Run(() => _context.PHRequests.Add(pharmacy));
            await _context.SaveChangesAsync();
        }

        public async Task<PharmacyHead> GetPharmacyHead(PharmacyHead pharmacyHead)
        {
            var Phead = await Task.Run(() => _context.PharmacyHeads.Where(x => x.Email.Equals(pharmacyHead.Email)).FirstOrDefault());
            return Phead;
        }

        public async Task<IQueryable<PharmacyHead>> GetPharmacyHeadInfo()
        {
            var PHeadInfo = await Task.Run(() => _context.PharmacyHeads.Take(10));
            return PHeadInfo;
        }

        public async Task UpdatePharmacyHead(PharmacyHead pharmacyHead)
        {
            var EditedPHead = await Task.Run(() => _context.PharmacyHeads.Where(x => x.Id == pharmacyHead.Id).FirstOrDefault());
            EditedPHead.Email = pharmacyHead.Email;
            EditedPHead.Name = pharmacyHead.Name;
            EditedPHead.Password = pharmacyHead.Password;
            EditedPHead.MedicineLists = pharmacyHead.MedicineLists;
            EditedPHead.PharmaciesList = pharmacyHead.PharmaciesList;
            await _context.SaveChangesAsync();
        }
    }
}
