﻿using FarmatikoData.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepoInterfaces
{
    public interface IRepository
    {
        //GET
        Task<IQueryable<HealthcareWorker>> GetAllWorkers();
        Task<IQueryable<HealthFacility>> GetFacilities();
        Task<HealthFacility> GetFacility(int Id);
        Task<Medicine> GetMedicine(int Id);
        Task<IQueryable<Medicine>> GetMedicines();
        Task<Pandemic> GetPandemic();
        Task<IQueryable<Pharmacy>> GetPharmacies();
        Task<Pharmacy> GetPharmacy(int id);
        Task<HealthcareWorker> GetWorker(int id);
        Task<IQueryable<HealthFacility>> SearchFacilities(string query);
        Task<IQueryable<Medicine>> SearchMedicines(string query);
        Task<IQueryable<Pharmacy>> SearchPharmacies(string query);
        Task<IQueryable<HealthcareWorker>> SearchWorkers(string query);
        Task<HealthFacility> GetFacilityJSON(string healthFacility);

        //POST
        Task AddWorker(HealthcareWorker Worker);
        Task AddFacility(HealthFacility healthFacility);
        Task AddPharmacy(Pharmacy pharmacy);
        Task AddPharmacyHead(PharmacyHead pharmacyHead);
        Task AddMedicines(Medicine medicine);
        Task AddPandemic(Pandemic pandemic);
        Task UpdateFacility(HealthFacility healthFacility);
        Task RemoveMedicine(Medicine medicine);
        Task UpdatePandemic(Pandemic pandemic);
        Task RemovePharmacy(Pharmacy pharmacy);
        Task UpdateWorker(HealthcareWorker worker);
        Task UpadatePharmacy(Pharmacy pharmacy);
        Task UpdateMedicine(Medicine medicine);
        Task RemovePharmacyHead(PharmacyHead pharmacyHead);
    }
}
