﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class AdminService : IAdminService
    {
        private readonly IAdminRepo _adminRepo;
        public AdminService(IAdminRepo adminRepo)
        {
            _adminRepo = adminRepo;
        }

        public async Task<IQueryable<RequestPharmacyHead>> GetCalimingRequests()
        {
            var req = await Task.Run(() => _adminRepo.GetClaimingRequests());
            return req;
        }

        public async Task<IQueryable<PharmacyHead>> GetPharmacyHeads()
        {
            var PHeads = await Task.Run(() => _adminRepo.GetPharmacyHeads());
            return PHeads;
        }

        public async Task RejectRequest(RequestPharmacyHead req)
        {
            await _adminRepo.RemoveClaimRequest(req);
        }
    }
}
