﻿using FarmatikoData.Models;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineListRepository : IMedicineListRepository
    {
        private FarmatikoDataContext _context;
        public MedicineListRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(MedicineList medicineList)
        {
            _context.MedicineLists.Add(medicineList);
            _context.SaveChangesAsync();
        }
        public MedicineList CheckMedicine(string Name)
        {
            return (MedicineList)_context.MedicineLists
                .Where(medicineList => medicineList.Medicine.Name.Contains(Name))
                .OrderBy(x => x.Medicine.Name);
        }

        public IEnumerable<MedicineList> GetAll()
        {
            return _context.MedicineLists.OrderBy(x => x.Medicine.Name);
        }

        public ICollection<MedicineList> GetByManufacturer(string Manufacturer)
        {
            return (ICollection<MedicineList>)_context.MedicineLists
                .Where(x => x.Medicine.Manufacturer.Contains(Manufacturer))
                .OrderBy(x => x.Medicine.Name);
        }
        public ICollection<MedicineList> GetByName(string Name)
        {
            return (ICollection<MedicineList>)_context.MedicineLists
                .Where(x => x.Medicine.Name.Contains(Name))
                .OrderBy(x => x.Medicine.Name);
        }

        public void Remove(MedicineList medicineList)
        {
            var list = (MedicineList)_context.MedicineLists.Where(x => x.Equals(medicineList));
            _context.MedicineLists.Remove(list);
        }

        public bool SetHasMedicine(MedicineList medicineList, bool HasMedicine)
        {
            MedicineList medicine = (MedicineList)_context.MedicineLists.Where(x => x.Medicine.Name.Equals(medicineList.Medicine.Name));
            
            if (medicine != null || medicineList != null)
            {
                if (HasMedicine == true)
                {
                    medicine.HasMedicine = HasMedicine;
                    _context.MedicineLists.Add(medicine);
                    _context.SaveChangesAsync();
                    return true;
                }
                else
                {
                    medicine.HasMedicine = HasMedicine;
                    _context.MedicineLists.Add(medicine);
                    _context.SaveChangesAsync();
                    return true;
                }
            }else
            {
                return false;
            }
        }
    }
}
