﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineRepository : IMedicineRepository
    {
        private FarmatikoDataContext _context;
        public MedicineRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(Medicine Medicine)
        {
            _context.Add(Medicine);
            _context.SaveChangesAsync();
        }

        public IEnumerable<Medicine> GetAll()
        {
            return _context.Medicines.OrderBy(x => x.Name);
        }

        public IEnumerable<Medicine> GetByManufacturer(string Manufacturer)
        {
            return _context.Medicines.Where(x => x.Name.Contains(Manufacturer)).OrderBy(x => x.Manufacturer);
        }

        public IEnumerable<Medicine> GetByName(string Name)
        {
            return _context.Medicines.Where(medicine => medicine.Name == Name);
        }

        public void Remove(string medicine)
        {
            Medicine med = (Medicine)_context.Medicines.Where(medicine => medicine.Name.Equals(medicine));
            _context.Medicines.Remove(med);
        }
    }
}
