﻿using FarmatikoData.FarmatikoRepo;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System.Collections.Generic;

namespace FarmatikoServices.Services
{
    public class MedicineListService : IMedicineListService
    {
        private IMedicineListRepository _medicineListRepository;
        public MedicineListService(IMedicineListRepository medicineListRepository)
        {
            _medicineListRepository = medicineListRepository;
        }

        public IEnumerable<MedicineList> GetAll()
        {
            return _medicineListRepository.GetAll();
        }

        public ICollection<MedicineList> GetByManufacturer(string Manufacturer)
        {
            return _medicineListRepository.GetByManufacturer(Manufacturer);
        }

        public ICollection<MedicineList> GetByName(string Name)
        {
            if(Name != null)
            {
                return _medicineListRepository.GetByName(Name);
            }
            return null;
        }

        public bool SetHasMedicine(MedicineList medicineList, bool HasMedicine)
        {
            if (medicineList != null)
            {
                _medicineListRepository.SetHasMedicine(medicineList, HasMedicine);
                return true;
            }
            else return false;
        }
    }
}
