﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class Service : IService
    {
        private readonly IRepository _repository;
        public Service(IRepository repository)
        {
            _repository = repository;
        }

        //GET
        public async Task<IQueryable<HealthcareWorkers>> GetAllWorkers()
        {
            var Workers = await _repository.GetAllWorkers();
            return Workers;
        }

        public async Task<IQueryable<HealthFacilities>> GetFacilities()
        {
            var Facilities = await _repository.GetFacilities();
            return Facilities;
        }

        public async Task<HealthFacilities> GetFacility(int id)
        {
            var Facility = await _repository.GetFacility(id);
            return Facility;
        }

        public async Task<Medicine> GetMedicine(int id)
        {
            var Medicine = await _repository.GetMedicine(id);
            return Medicine;
        }

        public async Task<IQueryable<Medicine>> GetMedicines()
        {
            var Medicines = await _repository.GetMedicines();
            return Medicines;
        }

        public async Task<Pandemic> GetPandemic()
        {
            var Pandemic = await _repository.GetPandemic();
            return Pandemic;
        }

        public async Task<IQueryable<Pharmacy>> GetPharmacies()
        {
            var Pharmacies = await _repository.GetPharmacies();
            return Pharmacies;
        }

        public async Task<Pharmacy> GetPharmacy(int id)
        {
            var Pharmacy = await _repository.GetPharmacy(id);
            return Pharmacy;
        }

        public async Task<HealthcareWorkers> GetWorker(int id)
        {
            var Worker = await _repository.GetWorker(id);
            return Worker;
        }

        public async Task<IQueryable<HealthFacilities>> SearchFacilities(string query)
        {
            var SearchQuery = await _repository.SearchFacilities(query);
            return SearchQuery;
        }

        public async Task<IQueryable<Medicine>> SearchMedicines(string query)
        {
            var SearchQuery = await _repository.SearchMedicines(query);
            return SearchQuery;
        }

        public async Task<IQueryable<Pharmacy>> SearchPharmacies(string query)
        {
            var SearchQuery = await _repository.SearchPharmacies(query);
            return SearchQuery;
        }

        public async Task<IQueryable<HealthcareWorkers>> SearchWorkers(string query)
        {
            var SearchQuery = await _repository.SearchWorkers(query);
            return SearchQuery;
        }


        //POST (ADD NEW OBJECTS)
        public Task AddFacility(HealthFacilities healthFacilities)
        {
            if (healthFacilities != null)
                _repository.AddFacility(healthFacilities);
            throw new Exception("Facility is null");
        }

        public Task AddMedicines(Medicine medicine)
        {
            if (medicine != null)
                _repository.AddMedicines(medicine);
            throw new Exception("Medicine is null");
        }

        public Task AddPandemic(Pandemic pandemic)
        {
            if (pandemic != null)
                _repository.AddPandemic(pandemic);
            throw new Exception("Pandemic is null");
        }

        public Task AddPharmacy(Pharmacy pharmacy)
        {
            if (pharmacy != null)
                _repository.AddPharmacy(pharmacy);
            throw new Exception("Pharmacy is null");
        }

        public Task AddPharmacyHead(PharmacyHead pharmacyHead)
        {
            if (pharmacyHead != null)
                _repository.AddPharmacyHead(pharmacyHead);
            throw new Exception("PharmacyHead is null");
        }

        public Task AddWorker(HealthcareWorkers worker)
        {
            if (worker != null)
                _repository.AddWorker(worker);
            throw new Exception("Worker is null");
        }

        //PUT (EDIT OBJECTS)


        //DELETE

    }
}
