﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineRepository : IMedicineRepository
    {
        private FarmatikoDataContext _context;
        public MedicineRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(Medicine Medicine)
        {
            _context.Medicines.Add(Medicine);
            _context.SaveChangesAsync();
        }

        public IQueryable<Medicine> GetAll()
        {
            return _context.Medicines.Take(50).Select(x => new Medicine
            {
                Name = x.Name,
                Strength = x.Strength,
                Form = x.Form,
                WayOfIssuing = x.WayOfIssuing,
                Manufacturer = x.Manufacturer,
                Price = x.Price,
                Packaging = x.Packaging
            }).OrderBy(x => x.Name);
        }

        public IQueryable<Medicine> GetByManufacturer(string Manufacturer)
        {
            return _context.Medicines.Take(50).Where(x => x.Name.Contains(Manufacturer))
                .Select(x => new Medicine
                {
                    Name = x.Name,
                    Strength = x.Strength,
                    Form = x.Form,
                    WayOfIssuing = x.WayOfIssuing,
                    Manufacturer = x.Manufacturer,
                    Price = x.Price,
                    Packaging = x.Packaging
                }).OrderBy(x => x.Manufacturer);
        }

        public IQueryable<Medicine> GetByName(string Name)
        {
            return _context.Medicines.Take(50).Where(medicine => medicine.Name.Contains(Name))
                .Select(x => new Medicine
                {
                    Name = x.Name,
                    Strength = x.Strength,
                    Form = x.Form,
                    WayOfIssuing = x.WayOfIssuing,
                    Manufacturer = x.Manufacturer,
                    Price = x.Price,
                    Packaging = x.Packaging
                }).OrderBy(x => x.Name);
        }

        public void Remove(Medicine medicine)
        {
            Medicine med = _context.Medicines.Where(medicine => medicine.Name.Equals(medicine.Name)).FirstOrDefault();
            if (med != null)
            {
                _context.Medicines.Remove(med);
                _context.SaveChangesAsync();
            }

        }
    }
}
