﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class PandemicService : IPandemicService
    {
        private IPandemicRepository _pandemicRepository;
        public PandemicService(IPandemicRepository pandemicRepository)
        {
            _pandemicRepository = pandemicRepository;
        }

        public async void Add(Pandemic pandemic)
        {
            if (pandemic != null)
                await Task.Run(() => _pandemicRepository.Add(pandemic));
            else throw new Exception("Can't add pandemic is null.");
        }

        public async Task<IQueryable<Pandemic>> GetAll()
        {
            return await Task.Run(() => _pandemicRepository.GetAll());
        }

        public async void Remove(Pandemic pandemic)
        {
            if (pandemic != null)
                await Task.Run(() => _pandemicRepository.Remove(pandemic));
            else throw new Exception("Can't remove, pandemic is null.");
        }
    }
}
