﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("[controller]/[action]")]
    public class MedicineListController : Controller
    {
        private IMedicineListService _medicineListService;
        public MedicineListController(IMedicineListService medicineListService)
        {
            _medicineListService = medicineListService;
        }
        [HttpGet]
        public Task<IQueryable<MedicineList>> Get()
        {
            return _medicineListService.GetAll();
        }
        [HttpGet]
        public Task<ICollection<MedicineList>> GetByName(string Name)
        {
            return _medicineListService.GetByName(Name);
        }
        [HttpGet]
        public Task<ICollection<MedicineList>> GetByManufacturer(string Manufacturer)
        {
            return _medicineListService.GetByManufacturer(Manufacturer);
        }
        /*[HttpPost]
        public void SetHasMedicine(MedicineList medicineList, bool HasMedicine)
        {
            _medicineListService.SetHasMedicine(medicineList, HasMedicine);
        }*/
        [HttpPost]
        public void Add(MedicineList medicineList)
        {
            _medicineListService.Add(medicineList);
        }
        [HttpPost]
        public void Remove(MedicineList medicineList)
        {
            _medicineListService.Remove(medicineList);
        }
    }
}
