﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class PandemicRepository : IPandemicRepository
    {
        private FarmatikoDataContext _context;

        public PandemicRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(Pandemic pandemic)
        {
            _context.Pandemics.Add(pandemic);
            _context.SaveChangesAsync();
        }

        public IQueryable<Pandemic> GetAll()
        {
            return _context.Pandemics.Select(x => new Pandemic
            {
                Name = x.Name,
                TotalMK = x.TotalMK,
                ActiveMK = x.ActiveMK,
                DeathsMK = x.DeathsMK,
                NewMK = x.NewMK,
                TotalGlobal = x.TotalGlobal,
                DeathsGlobal = x.DeathsGlobal,
                ActiveGlobal = x.ActiveGlobal
            }).OrderBy(x => x.Name);
        }

        public void Remove(Pandemic pandemic)
        {
            var Pandem = _context.Pandemics.Where(x => x.Name.Equals(pandemic.Name)).FirstOrDefault();
            if (Pandem != null)
            {
                _context.Pandemics.Remove(Pandem);
                _context.SaveChangesAsync();
            }
        }
    }
}
