﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class PharmacyRepository : IPharmacyRepository
    {
        private FarmatikoDataContext _context;

        public PharmacyRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(Pharmacy pharmacy)
        {
            _context.Pharmacies.Add(pharmacy);
            _context.SaveChanges();
        }
        //Just for users
        public IQueryable<Pharmacy> GetAll()
        {
            return _context.Pharmacies.Take(50)
                .Select(x => new Pharmacy
                {
                    Name = x.Name,
                    Location = x.Location,
                    Address = x.Address,
                    WorkAllTime = x.WorkAllTime
                }).OrderBy(x => x.Name);
        }

        public ICollection<Pharmacy> GetPharmacies()
        {
            return (ICollection<Pharmacy>)_context.Pharmacies.Take(50)
                .Select(pharmacy => new
                {
                    pharmacy.Name,
                    pharmacy.Address,
                    pharmacy.Location,
                    pharmacy.WorkAllTime
                }).OrderBy(x => x.Name);
        }

        public void Remove(Pharmacy pharmacy)
        {
            var pharma = _context.Pharmacies.Where(pharm => pharm.Name.Equals(pharmacy.Name)).FirstOrDefault();
            if (pharma != null)
            {
                _context.Pharmacies.Remove(pharmacy);
                _context.SaveChangesAsync();
            }
        }

        public void UpdatePharmacy(Pharmacy pharmacy)
        {
            var oldPharmacy = _context.Pharmacies.Where(pharma => pharma.Name.Equals(pharmacy.Name)).FirstOrDefault();
            if (oldPharmacy != null)
            {
                _context.Pharmacies.Remove(oldPharmacy);
                _context.Pharmacies.Add(pharmacy);
                _context.SaveChangesAsync();
            }
            throw new Exception("Pharmacy not found");
        }
    }
}
