import { Component, OnInit, ViewChild, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Medicine } from '../models/Medicine';
import { Pharmacy } from '../models/Pharmacy';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';

@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.css']
})
export class HomeComponent implements OnInit {
  public medicines: Medicine[];
  public pharmacies: Pharmacy[];
  displayedColumns = ['Име','Јачина','Форма', 'Начин на издавање', 'Производител', 'Цена', 'Пакување'];
  displayedColumnsPharmacies = ['Име','Локација','Адреса', 'Работи 27/7?'];
  dataSource = new MatTableDataSource<Medicine>();
  dataSourcePharmacies = new MatTableDataSource<Pharmacy>();

  @ViewChild(MatPaginator, {static: true}) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;

  constructor(http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    http.get<Medicine[]>(baseUrl + 'Medicine/Get?').subscribe(result => {
      this.medicines = result;
      console.log(this.medicines);
      this.dataSource = new MatTableDataSource<Medicine>(this.medicines);
    }, error => console.error(error));
    http.get<Pharmacy[]>(baseUrl + 'Pharmacy/Get?').subscribe(result => {
      this.pharmacies = result;
      console.log(this.pharmacies);
      this.dataSourcePharmacies = new MatTableDataSource<Pharmacy>(this.pharmacies);
    }, error => console.error(error));
  }
  ngOnInit(): void {
  }

  ngAfterViewInit(): void {
    this.dataSource.paginator = this.paginator;
    this.dataSource.sort = this.sort;
    this.dataSourcePharmacies.paginator = this.paginator;
    this.dataSourcePharmacies.sort = this.sort;
  }

  applyFilter(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSource.filter = filterValue;
  }
  
  applyFilterPharmacies(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSourcePharmacies.filter = filterValue;
  }
}
