﻿using FarmatikoData.FarmatikoRepoInterfaces;
using System.Linq;
using FarmatikoData.Models;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthFacilityRepository : IHealthFacilityRepository
    {
        private FarmatikoDataContext _context;

        public HealthFacilityRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthFacilities healthFacility)
        {
            _context.Add(healthFacility);
            _context.SaveChanges();
        }

        public IQueryable<HealthFacilities> GetAll()
        {
            return _context.HealthFacilities.OrderBy(x => x.Name);
        }

        public void Remove(HealthFacilities healthFacility)
        {
            var facility = _context.HealthFacilities.Where(x => x.Name.Equals(healthFacility.Name));
            _context.HealthFacilities.Remove((HealthFacilities)facility);
        }
    }
}
