﻿using FarmatikoData;
using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Linq;

namespace FarmatikoServices
{
    public class HealthFacilityService : IHealthFacilityService
    {
        private IHealthFacilityRepository _healthFacilityRepository;

        public HealthFacilityService(IHealthFacilityRepository healthFacilityRepository)
        {
            _healthFacilityRepository = healthFacilityRepository;
        }

        public void Add(HealthFacilities healthFacility)
        {
            try
            {
                if (healthFacility != null)
                    _healthFacilityRepository.Add(healthFacility);
            }
            catch (Exception e)
            {
                e = new Exception("Can't Add health facility is null");
                throw e;
            }
        }

        public IQueryable<HealthFacilities> GetAll()
        {
            return _healthFacilityRepository.GetAll();
        }

        public void Remove(HealthFacilities healthFacility)
        {
            try
            {
                if (healthFacility != null)
                    _healthFacilityRepository.Remove(healthFacility);
            } 
            catch(Exception e)
            {
                e = new Exception("Can't Remove health facility is null");
                throw e;
            }
        }
    }
}
