﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Linq;

namespace FarmatikoServices.Services
{
    public class PharmacyHeadService : IPharmacyHeadService
    {
        private IPharmacyHeadRepository _pharmacyHeadRepository;
        public PharmacyHeadService(IPharmacyHeadRepository pharmacyHeadRepository)
        {
            _pharmacyHeadRepository = pharmacyHeadRepository;
        }

        public void Add(PharmacyHead pharmacyHead)
        {
            try
            {
                if (pharmacyHead != null)
                {
                    _pharmacyHeadRepository.Add(pharmacyHead);
                }
            }
            catch (Exception e)
            {
                e = new Exception("Can't add, pharmacy head is null.");
            }

        }

        public IQueryable<PharmacyHead> GetAllPharmacies(string NameOfPharmacyHead)
        {
            if (NameOfPharmacyHead != null)
            {
                IQueryable<PharmacyHead> Pharmacy = _pharmacyHeadRepository.GetAllPharmacies(NameOfPharmacyHead);
                if (Pharmacy != null)
                    return Pharmacy;
            }
            return null;
        }

        public IQueryable<PharmacyHead> GetPharmacyByName(string Name)
        {
            if (Name != null)
            {
                IQueryable<PharmacyHead> PharmacyHead = _pharmacyHeadRepository.GetPharmacyByName(Name);
                if (PharmacyHead != null)
                    return PharmacyHead;
            }
            return null;
        }

        public IQueryable<MedicineList> GetPharmacyMedicines(string NameOfPharmacy)
        {
            if (NameOfPharmacy != null)
            {
                IQueryable<MedicineList> Medicines = _pharmacyHeadRepository.GetPharmacyMedicines(NameOfPharmacy);
                if (Medicines != null)
                    return Medicines;
            }
            return null;
        }

        public void Remove(PharmacyHead pharmacyHead, string Name)
        {
            try
            {
                if (Name != null)
                {
                    _pharmacyHeadRepository.Remove(pharmacyHead, Name);
                }
            }
            catch (Exception e)
            {
                e = new Exception("Can't remove, name of pharmacy head is null.");
            }

        }
    }
}
