﻿using FarmatikoData;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Threading.Tasks;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("[controller]/[action]")]
    public class HealthFacilitiesController : Controller
    {
        private IHealthFacilityService _healthFacilitiesService;
        private IProcessJSONService _processJSONService;
        public HealthFacilitiesController(IHealthFacilityService healthFacilitiesService, IProcessJSONService processJSONService)
        {
            _healthFacilitiesService = healthFacilitiesService;
            _processJSONService = processJSONService;
        }
        [HttpGet]
        public IQueryable<HealthFacilities> Get()
        {
            return _healthFacilitiesService.GetAll();
        }
        public void Index()
        {
            _processJSONService.GetProcessedHealthFacilitiesFromJSON();
        }
    }
}
