import { Component, OnInit, ViewChild, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { HealthFacilities } from '../models/HealthFacilities';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';

@Component({
  selector: 'app-counter-component',
  templateUrl: './counter.component.html',
  styleUrls: ['./counter.component.css']
})
export class CounterComponent implements OnInit {
  public facilities: HealthFacilities[];
  displayedColumns = ['Име','Општина','Адреса', 'Тип', 'Е-пошта', 'Телефон'];
  dataSource = new MatTableDataSource<HealthFacilities>();

  @ViewChild(MatPaginator, {static: true}) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;

  constructor(http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    http.get<HealthFacilities[]>(baseUrl + 'HealthFacilities/Get?').subscribe(result => {
      this.facilities = result;
      console.log(this.facilities);
      this.dataSource = new MatTableDataSource<HealthFacilities>(this.facilities);
    }, error => console.error(error));
  }
  ngOnInit(): void {
  }

  ngAfterViewInit(): void {
    this.dataSource.paginator = this.paginator;
    this.dataSource.sort = this.sort;
  }

  applyFilter(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSource.filter = filterValue;
  }
}