--delete tables
drop table if exists project.UserFavourites;
drop table if exists project.UserComments;
drop table if exists project.Ratings;
drop table if exists project.WatchListProducts;
drop table if exists project.ProductImages;
drop table if exists project.ProductInstances;
drop table if exists project.belongs_to;
drop table if exists project.Users;
drop table if exists project.Roles;
drop table if exists project.Products;
drop table if exists project.ProductCharacteristics;
drop table if exists project.Manufacturers;
drop table if exists project.Categories;
drop table if exists project.Stores;


--create tables
create table project.Roles(
	roleId serial not null,
	roleDescription varchar(300) not null,
	roleName varchar(100) not null,
	
	constraint pk_Roles primary key (roleId),
	constraint un_Roles_roleName unique (roleName)
);

create table project.Users(
	userId serial not null,
	userUsername varchar(100) not null,
	userPassword varchar(200) not null,
	userName varchar(100) not null,
	userSurname varchar(100) not null,
	userPictureUrl varchar(200),
	userEmail varchar(100) not null,
	userPhoneNumber varchar(100) not null,
	
	roleId integer not null,
	
	constraint pk_Users primary key (userId),
	constraint un_Users_userUsername unique (userUsername),
	constraint un_Users_userEmail unique (userEmail),
	constraint fk_Users_Roles foreign key (roleId) references project.Roles(roleId)
);


create table project.Manufacturers(
	manufacturerId serial not null,
	manufacturerName varchar(100) not null,
	manufacturerCountry varchar(100) not null,
	
	constraint pk_Manufacturers primary key (manufacturerId),
	constraint un_Manufacturers_manufacturerName unique (manufacturerName)
);

create table project.Categories(
	categoryId serial not null,
	parentCategoryId integer,
	categoryName varchar(100) not null,
	
	constraint pk_Categories primary key (categoryId),
	constraint un_Categories_categoryName unique (categoryName),
	constraint fk_Categories_Categories foreign key (parentCategoryId) references project.Categories(categoryId)
);

create table project.ProductCharacteristics(
	characteristicId serial not null,
	characteristicDescription varchar(300) not null,
	
	constraint pk_ProductCharacteristics primary key (characteristicId)
);

create table project.Products (
	productId serial not null,
	productName varchar(100) not null,
	postDate date not null,
	
	manufacturerId integer not null,
	categoryId integer not null,
	characteristicId integer not null,
	
	constraint pk_Products primary key (productId),
	constraint un_Products_productName unique (productName),
	constraint un_Products_characteristicId unique (characteristicId),
	constraint fk_Products_Manufacturers foreign key (manufacturerId) references project.Manufacturers(manufacturerId),
	constraint fk_Products_Categories foreign key (categoryId) references project.Categories(categoryId),
	constraint fk_Products_ProductCharacteristics foreign key (characteristicId) references project.ProductCharacteristics(characteristicId)
);

create table project.UserFavourites(
	userFavouriteId serial not null,
	userId integer not null,
	productId integer not null,
	
	constraint pk_UserFavourites primary key (userFavouriteId),
	constraint fk_UserFavourites_Users foreign key (userId) references project.Users(userId),
	constraint fk_UserFavourites_Products foreign key (productId) references project.Products(productId)
);

create table project.UserComments(
	commentId serial not null,
	userComment varchar(300) not null,

	userId integer not null,
	productId integer not null,
	
	constraint pk_UserComments primary key (commentId),
	constraint fk_UserComments_Users foreign key (userId) references project.Users(userId),
	constraint fk_UserComments_Products foreign key (productId) references project.Products(productId)
);

create table project.Ratings (
 	ratingId serial not null,
 	ratingValue integer not null,
 	
 	userId integer not null,
 	productId integer not null,
 	
 	constraint pk_Ratings primary key (ratingId),
 	constraint fk_Ratings_Users foreign key (userId) references project.Users(userId),
 	constraint fk_Ratings_Products foreign key (productId) references project.Products(productId)
);

create table project.WatchListProducts(
	watchListProductId serial not null,
	priceLimit integer not null,
	
	userId integer not null,	
	productId integer not null,
	
	constraint pk_WatchListProducts primary key (watchListProductId),
	constraint fk_WatchListProducts_Users foreign key (userId) references project.Users(userId),
	constraint fk_WatchListProducts_Products foreign key (productId) references project.Products(productId)
);

create table project.ProductImages(
	productImageId serial not null,
	productImageUrl varchar(100) not null,
	
	productId integer not null,
	
	constraint pk_ProductImages primary key (productImageId),
	constraint fk_ProductImages_Products foreign key (productId) references project.Products(productId)
);

create table project.Stores(
	storeId serial not null,
	storeName varchar(100) not null,
	
	constraint pk_Stores primary key (storeId),
	constraint un_Stores_storeName unique (storeName)
);

create table project.ProductInstances(
	productInstanceId serial not null,
	productInstancePrice integer not null,
	
	productId integer not null,
	storeId integer not null,

	constraint pk_ProductInstances primary key (productInstanceId),
	constraint fk_ProductInstances_Products foreign key (productId) references project.Products(productId),
	constraint fk_ProductInstances_Stores foreign key (storeId) references project.Stores(storeId)
);


create table project.belongs_to(
	productId integer not null,
	categoryId integer not null,
	
	constraint pk_belongs_to primary key (productId, categoryId),
	constraint fk_belongs_to_Products foreign key (productId) references project.Products(productId),
	constraint fk_belongs_to_Categories foreign key (categoryId) references project.Categories(categoryId)
);