const nodemailer = require('nodemailer');
require('dotenv').config();

// Create transporter with Mailtrap SMTP
const transporter = nodemailer.createTransport({
  host: process.env.SMTP_HOST,
  port: Number(process.env.SMTP_PORT || 2525),
  auth: {
    user: process.env.SMTP_USER,
    pass: process.env.SMTP_PASS,
  },
});

/**
 * Send email using Mailtrap
 * @param {Object} options - Email options
 * @param {string} options.to - Recipient email address
 * @param {string} options.subject - Email subject
 * @param {string} options.html - HTML content
 * @param {string} options.text - Plain text content (optional)
 */
async function sendMail({ to, subject, html, text }) {
  try {
    if (!to) {
      console.error('Email send failed: No recipient specified');
      return null;
    }

    const mailOptions = {
      from: process.env.EMAIL_FROM || 'Kupi.mk <no-reply@kupi-mk.local>',
      to,
      subject,
      text: text || subject,
      html,
    };

    const info = await transporter.sendMail(mailOptions);
    console.log('✅ Email sent:', info.messageId, '→', to);
    return info;
  } catch (error) {
    console.error('❌ Email send error:', error.message);
    return null;
  }
}

module.exports = { sendMail };
