// Seller Route Protection Component
// - Purpose: protect seller-only pages from non-seller users
// - Redirects non-sellers to home page with message

import React from 'react';
import { Navigate } from 'react-router-dom';
import { useAuth } from '../context/AuthContext';

const SellerRoute = ({ children }) => {
    const { user, isAuthenticated, loading } = useAuth();

    if (loading) {
        return (
            <div className="min-h-screen flex items-center justify-center">
                <div className="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600"></div>
            </div>
        );
    }

    if (!isAuthenticated()) {
        return <Navigate to="/login" replace />;
    }

    if (!user?.is_seller) {
        // Redirect non-sellers to home page
        alert('Оваа страница е достапна само за продавачи. Регистрирајте се како продавач за да добиете пристап.');
        return <Navigate to="/" replace />;
    }

    return children;
};

export default SellerRoute;