# Google OAuth Setup Instructions

## ✅ Installation Complete!

All necessary packages have been installed and code has been implemented. Now you need to complete the setup:

---

## Step 1: Update Database Schema

Run this SQL script to add Google OAuth support to your database:

```bash
psql -U admin -d kupi_mk -f database_updates_oauth.sql
```

Or manually run these SQL commands:

```sql
ALTER TABLE users ADD COLUMN IF NOT EXISTS google_id VARCHAR(255) UNIQUE;
ALTER TABLE users ALTER COLUMN password DROP NOT NULL;
CREATE INDEX IF NOT EXISTS idx_users_google_id ON users(google_id);
```

---

## Step 2: Get Google OAuth Credentials

### A. Create Google Cloud Project

1. **Go to:** https://console.cloud.google.com/
2. **Create New Project:**
   - Click project dropdown → "New Project"
   - Name: "Kupi-mk"
   - Click "Create"

3. **Enable Google+ API:**
   - Sidebar: **APIs & Services** → **Library**
   - Search: "Google+ API"
   - Click and press "Enable"

4. **Configure OAuth Consent Screen:**
   - Go to: **APIs & Services** → **OAuth consent screen**
   - Choose: **External**
   - Fill in:
     - App name: `Kupi-mk`
     - User support email: Your email
     - Developer contact: Your email
   - Click "Save and Continue" (skip Scopes and Test users)

5. **Create OAuth Credentials:**
   - Go to: **APIs & Services** → **Credentials**
   - Click: **"+ CREATE CREDENTIALS"** → **OAuth client ID**
   - Application type: **Web application**
   - Name: `Kupi.mk Web Client`
   - **Authorized JavaScript origins:**
     - `http://localhost:3000`
   - **Authorized redirect URIs:**
     - `http://localhost:5001/api/auth/google/callback`
   - Click "Create"

6. **Copy Credentials:**
   - Copy **Client ID** and **Client Secret**
   - Save them for the next step!

---

## Step 3: Update .env File

Open `/home/aleksandar/Documents/IT proekt/kupi-mk/backend/.env` and replace:

```env
GOOGLE_CLIENT_ID=YOUR_GOOGLE_CLIENT_ID_HERE
GOOGLE_CLIENT_SECRET=YOUR_GOOGLE_CLIENT_SECRET_HERE
```

With your actual Google credentials from Step 2.

---

## Step 4: Start the Servers

1. **Start Backend:**
```bash
cd /home/aleksandar/Documents/IT\ proekt/kupi-mk/backend
npm run dev
```

2. **Start Frontend (in a new terminal):**
```bash
cd /home/aleksandar/Documents/IT\ proekt/kupi-mk/frontend
npm start
```

---

## Step 5: Test Google OAuth

1. Open: http://localhost:3000/login
2. Click: "Најави се со Google" button
3. Select your Google account
4. You should be redirected back and logged in!

---

## ✨ What's Implemented

### Backend (`/backend`):
- ✅ **passport.js** - Google OAuth strategy
- ✅ **auth.js routes** - `/api/auth/google` and `/api/auth/google/callback`
- ✅ **server.js** - Passport middleware initialized
- ✅ **Database** - Added `google_id` column to users table

### Frontend (`/frontend`):
- ✅ **GoogleLoginButton.js** - Reusable Google login button component
- ✅ **OAuthCallback.js** - Handles OAuth redirect and saves token
- ✅ **Login.js** - Added Google login button with "or" divider
- ✅ **Register.js** - Added Google registration button
- ✅ **App.js** - Added `/oauth/callback` route

### Features:
- 🔒 **Hybrid Authentication**: Users can login with email/password OR Google
- 🔗 **Account Linking**: If Google email matches existing user, accounts are linked
- 🆕 **Auto-Registration**: New Google users are automatically registered
- 🎨 **Macedonian UI**: All text in Macedonian (Macedonian language)
- ✅ **JWT Tokens**: OAuth users still get JWT tokens for API access

---

## Troubleshooting

### Error: "redirect_uri_mismatch"
- Check that `http://localhost:5001/api/auth/google/callback` is in your Google Console redirect URIs

### Error: "invalid_client"
- Verify your `GOOGLE_CLIENT_ID` and `GOOGLE_CLIENT_SECRET` in `.env`

### Database Error
- Make sure you ran the SQL migration to add `google_id` column

### OAuth loop/not logging in
- Check browser console (F12) for errors
- Verify `FRONTEND_URL=http://localhost:3000` in backend `.env`

---

## Production Deployment

When deploying to production, add these to Google Console:

**Authorized JavaScript origins:**
- `https://yourdomain.com`

**Authorized redirect URIs:**
- `https://yourdomain.com/api/auth/google/callback`

And update your `.env`:
```env
GOOGLE_CALLBACK_URL=https://yourdomain.com/api/auth/google/callback
FRONTEND_URL=https://yourdomain.com
```

---

## 🎉 You're Done!

Once you complete Steps 1-4, your app will support Google OAuth login alongside your existing email/password system!
