# 📚 Complete Setup Documentation Index

Welcome to Kupi.mk! This page helps you find the right setup guide for your needs.

## 🚀 Quick Start (Most Users)

**Just want to get started quickly?**

### Windows Users:
1. Download and install PostgreSQL from [official website](https://www.postgresql.org/download/windows/)
2. Double-click `setup-database-windows.bat` in the project root
3. Double-click `start-servers-windows.bat` to start everything
4. Open http://localhost:3000 in your browser

### Linux/Mac Users:
1. Install PostgreSQL: `sudo apt install postgresql` (Ubuntu) or `brew install postgresql` (Mac)
2. Run: `./kupi-mk/start-servers.sh`
3. Open http://localhost:3000 in your browser

## 📖 Detailed Documentation

Choose the guide that fits your situation:

### 🪟 Windows Users
- **[WINDOWS_DATABASE_SETUP.md](WINDOWS_DATABASE_SETUP.md)** - Complete PostgreSQL setup guide for Windows
  - Multiple installation methods (Official installer, Docker, pgAdmin)
  - Step-by-step screenshots and instructions
  - Troubleshooting section
  - Environment configuration

### 🚀 All Platforms
- **[QUICK_SETUP.md](QUICK_SETUP.md)** - Fast setup guide for all operating systems
  - Automated scripts for Windows/Linux/Mac
  - Visual guide with file structure
  - Verification steps
  - Common issues and solutions

- **[README.md](README.md)** - Main project documentation
  - Project overview and features
  - Technology stack
  - Manual installation steps
  - Development workflow

## 🛠️ Setup Scripts Reference

### Automated Database Setup
| Platform | Script | Description |
|----------|--------|-------------|
| Windows (Batch) | `setup-database-windows.bat` | Simple batch script with prompts |
| Windows (PowerShell) | `setup-database-windows.ps1` | Advanced script with colors and validation |
| Linux/Mac | Manual setup in start script | Integrated into start-servers.sh |

### Server Management
| Platform | Start Script | Stop Script |
|----------|-------------|------------|
| Windows | `start-servers-windows.bat` | `stop-servers-windows.bat` |
| Windows | `start-servers-windows.ps1` | Built into PowerShell script |
| Linux/Mac | `kupi-mk/start-servers.sh` | `kupi-mk/stop-servers.sh` |

### VS Code Integration
- **Tasks**: Use `Ctrl+Shift+P` → "Tasks: Run Task"
  - Install Backend Dependencies
  - Install Frontend Dependencies  
  - Start Backend Server
  - Start Frontend Server
  - Stop All Servers

## 🎯 What Each File Does

```
📁 Project Root
├── 📄 README.md                      # Main project documentation
├── 📄 WINDOWS_DATABASE_SETUP.md      # Detailed Windows PostgreSQL guide
├── 📄 QUICK_SETUP.md                 # Fast setup for all platforms
├── 📄 SETUP_INDEX.md                 # This file - documentation index
├── 🚀 setup-database-windows.bat     # Windows database setup (simple)
├── 🚀 setup-database-windows.ps1     # Windows database setup (advanced)
├── 🚀 start-servers-windows.bat      # Windows server startup
├── 🚀 start-servers-windows.ps1      # Windows server startup (PowerShell)
├── 🚀 stop-servers-windows.bat       # Windows server shutdown
├── 📦 package.json                   # Root workspace configuration
└── 📁 .vscode/
    ├── 📄 tasks.json                 # VS Code tasks (cross-platform)
    ├── 📄 launch.json                # VS Code debugging config
    └── 📄 settings.json              # VS Code workspace settings
```

## 🎯 Recommended Setup Path

### For Beginners:
1. **Windows**: Use `setup-database-windows.bat` → `start-servers-windows.bat`
2. **Mac/Linux**: Follow [QUICK_SETUP.md](QUICK_SETUP.md)

### For Developers:
1. Read [README.md](README.md) for project overview
2. Use VS Code tasks for development workflow
3. Refer to [WINDOWS_DATABASE_SETUP.md](WINDOWS_DATABASE_SETUP.md) for troubleshooting

### For Advanced Users:
1. Use PowerShell scripts on Windows
2. Customize `.env` configuration
3. Set up Docker if preferred
4. Use VS Code debugging configuration

## 🆘 Getting Help

### Common Issues:
1. **PostgreSQL not installed**: See [WINDOWS_DATABASE_SETUP.md](WINDOWS_DATABASE_SETUP.md)
2. **Port conflicts**: Check if other apps use ports 3000, 5000, 5432
3. **Permission errors**: Run scripts as Administrator (Windows)
4. **Path issues**: Ensure PostgreSQL is in system PATH

### Support Resources:
- 📖 Check the troubleshooting sections in each guide
- 🔍 Search for error messages in the documentation
- 🛠️ Try the alternative setup methods
- 💻 Use VS Code tasks for consistent behavior

## 🎉 Success Indicators

You know setup worked when:
- ✅ PostgreSQL service is running
- ✅ Database `kupi_mk` exists
- ✅ Backend starts without errors ("PostgreSQL Connected")
- ✅ Frontend loads at http://localhost:3000
- ✅ You can register/login to the application

---

**Most users can be up and running in under 5 minutes with the automated scripts!** 🚀
