-- Database Schema Export\n-- Generated on: 2025-09-13T09:20:04.834Z\n\n-- Database setup script for Kupi.mk
-- Run this after creating the database and user (admin/password123)

-- Create users table
CREATE TABLE IF NOT EXISTS users (
    id SERIAL PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    first_name VARCHAR(50) NOT NULL,
    last_name VARCHAR(50) NOT NULL,
    phone VARCHAR(20),
    address TEXT,
    is_seller BOOLEAN DEFAULT false,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create categories table
CREATE TABLE IF NOT EXISTS categories (
    id SERIAL PRIMARY KEY,
    name VARCHAR(100) UNIQUE NOT NULL,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Create products table
CREATE TABLE IF NOT EXISTS products (
    id SERIAL PRIMARY KEY,
    title VARCHAR(200) NOT NULL,
    description TEXT NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    category_id INTEGER REFERENCES categories(id),
    seller_id INTEGER REFERENCES users(id),
    images TEXT[],
    stock_quantity INTEGER DEFAULT 0,
    location VARCHAR(100),
    is_active BOOLEAN DEFAULT true,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert default categories
INSERT INTO categories (name, description) VALUES 
('Електроника', 'Мобилни телефони, лаптопи, таблети и друга електроника'),
('Облека и мода', 'Машка и женска облека, чевли, додатоци'),
('Дом и градина', 'Мебел, декорации, алатки за градина'),
('Спорт и рекреација', 'Спортска опрема, фитнес, активности на отворено'),
('Книги и медија', 'Книги, филмови, музика, игри'),
('Возила', 'Автомобили, мотори, делови'),
('Убавина и здравје', 'Козметика, парфеми, здравствени производи'),
('Храна и пијалаци', 'Свежа храна, органски производи, локални специјалитети')
ON CONFLICT (name) DO NOTHING;

-- Create indexes for better performance
CREATE INDEX IF NOT EXISTS idx_products_category ON products(category_id);
CREATE INDEX IF NOT EXISTS idx_products_seller ON products(seller_id);
CREATE INDEX IF NOT EXISTS idx_products_active ON products(is_active);
CREATE INDEX IF NOT EXISTS idx_products_created ON products(created_at DESC);
\n\n-- Users Data\nDELETE FROM users;\nINSERT INTO users (id, username, email, password, first_name, last_name, phone, address, is_seller, created_at, updated_at) VALUES (1, 'Alek', 'aleksandar.grozdanoski@students.finki.ukim.mk', '$2a$10$Mu2BRi5IYogtWbI5oG0d1eNrnA77zhrebhB4K8dyk8WszNO1AeMTS', 'Aleksandar', 'Grozdanoski', '+389 111 111 111', 'Test 11', true, '2025-07-08T15:31:19.026Z', '2025-07-08T15:31:19.026Z');\nINSERT INTO users (id, username, email, password, first_name, last_name, phone, address, is_seller, created_at, updated_at) VALUES (2, 'Финки', 'aleksandar.grozdanoski@gmail.com', '$2a$10$W96h4qhsXSE6SaOwKQTcBOuHejL8MTw7/noFxUcSUrBWPV7OQc9Y6', 'Александар', 'Грозданоски', '+389 77 728 802', 'Karposh', true, '2025-07-10T14:48:38.036Z', '2025-07-10T14:48:38.036Z');\n\n-- Categories Data\nDELETE FROM categories;\nINSERT INTO categories (id, name, description, created_at) VALUES (1, 'Електроника', 'Телефони, лаптопи, компјутери', '2025-07-08T15:23:29.408Z');\nINSERT INTO categories (id, name, description, created_at) VALUES (2, 'Облека', 'Машка, женска и детска облека', '2025-07-08T15:23:29.408Z');\nINSERT INTO categories (id, name, description, created_at) VALUES (3, 'Дом и градина', 'Мебел, декорации, алатки', '2025-07-08T15:23:29.408Z');\nINSERT INTO categories (id, name, description, created_at) VALUES (4, 'Спорт и рекреација', 'Спортска опрема и додатоци', '2025-07-08T15:23:29.408Z');\nINSERT INTO categories (id, name, description, created_at) VALUES (5, 'Книги и музика', 'Книги, CD-а, винили', '2025-07-08T15:23:29.408Z');\nINSERT INTO categories (id, name, description, created_at) VALUES (6, 'Автомобили', 'Возила и авто делови', '2025-07-08T15:23:29.408Z');\nINSERT INTO categories (id, name, description, created_at) VALUES (7, 'Храна и пијалоци', 'Локални производи', '2025-07-08T15:23:29.408Z');\nINSERT INTO categories (id, name, description, created_at) VALUES (8, 'Убавина и здравје', 'Козметика и здравствени производи', '2025-07-08T15:23:29.408Z');\n\n-- Products Data\nDELETE FROM products;\nINSERT INTO products (id, title, description, price, category_id, seller_id, images, stock_quantity, location, is_active, created_at, updated_at) VALUES (1, 'ASUS TUF Gaming F16 Gaming Laptop', ' About this item

    READY FOR ANYTHING – Dive headfirst into gaming on Windows 11 powered by the Intel Core 5 210H processor and an NVIDIA GeForce RTX 4050 laptop GPU with a Max TGP of 115W and NVIDIA Advanced Optimus.
    SUBTLE STYLING – The TUF Gaming F16 maintains its classic design, boasting a subtle embossed TUF logo on its sleek cover.
    IMMERSIVE VISUALS – The TUF Gaming F16’s FHD 144Hz display with 100% sRGB color draws you into the action. Adaptive-Sync technology reduces lag, minimizes stuttering, and eliminates visual tearing for ultra-smooth gameplay.
    MILITARY GRADE DURABILITY – As a TUF gaming machine, the F16 has been rigorously tested to meet Military Grade testing standard, MIL-STD-810H. Rest easy knowing this laptop will operate at peak performance in harsh conditions.
    EFFICIENT COOLING – Equipped with Arc Flow Fans, 4 exhaust vents, 5 dedicated heat pipes, and an anti-dust filter, the TUF Gaming F16 optimizes cooling performance without extra noise.
    AUDIO EXCELLENCE – Elevate your audio experience with Dolby Atmos and Hi-Res Audio on the TUF Gaming F16.
    XBOX GAME PASS ULTIMATE – Get a free 90-day pass and gain access to over 100 high-quality games. With games added all the time, there’s always something new to play.
', 30000.00, 1, 1, ARRAY['/uploads/products/images-1751989170759-623412890.jpg', '/uploads/products/images-1751989170761-868673686.jpg', '/uploads/products/images-1751989170763-257960560.jpg'], 2, 'Skopje', true, '2025-07-08T15:39:30.825Z', '2025-07-08T15:39:30.825Z');\nINSERT INTO products (id, title, description, price, category_id, seller_id, images, stock_quantity, location, is_active, created_at, updated_at) VALUES (2, 'Plant Based Cold Process Natural Bar Soap For Face And Body, With Premium Essential Oils, For Men And Women 3 Pack (Vanilla Orange)', '
    PREMIUM QUALITY: Traditional Cold Process Soap. Made by hand in Canada using 100% plant based and all natural ingredients. All natural aromas from premium essential oils and all natural colorants exclusively from minerals, clays and plant extracts.
    CLEAN & HEALTHY SKIN: Olive Oil, Coconut Oil, Shea Butter, Avocado Oil and Kaolin Clay leave your skin feeling nourished AND clean!
    NEVER SYNTHETIC: Our proprietary scents and colors are achieved exclusively from Premium Essential Oils and 100% Natural Clays, Minerals and Plant Extracts. NO phthalates, NO parabens, NO sulfates, NO silicones, NO micas or oxides, NO dyes.
    SUSTAINABLE AT OUR CORE: All ingredients are sourced sustainably and packaged in recycled kraft paperboard. Our products leave nothing but paper behind!
    THOUGHTFUL GIFT: Crate 61 Hand Made Traditional Bar Soaps make for a great gift! Choose from 15 scents and counting!
', 3000.00, 8, 1, ARRAY['/uploads/products/images-1752078188118-651572011.jpg', '/uploads/products/images-1752078188127-900106182.jpg', '/uploads/products/images-1752078188130-341642272.jpg'], 2, 'Skopje, Gjorce', false, '2025-07-09T16:05:48.797Z', '2025-07-09T16:23:08.139Z');\nINSERT INTO products (id, title, description, price, category_id, seller_id, images, stock_quantity, location, is_active, created_at, updated_at) VALUES (3, 'Dietz & Watson Kosher Pickles', 'Домашни кисели краставички тегла 300', 200.00, 7, 1, ARRAY['/uploads/products/images-1752077533009-579481821.jpg', '/uploads/products/images-1752077533014-946225510.jpg', '/uploads/products/images-1752077533017-203334489.jpg'], 100, 'Prilep', true, '2025-07-09T16:12:13.037Z', '2025-07-09T16:12:13.037Z');\nINSERT INTO products (id, title, description, price, category_id, seller_id, images, stock_quantity, location, is_active, created_at, updated_at) VALUES (4, 'Flash Furniture Elon Series Plastic Modern Dining Chair with Wooden Legs, Mid-Century Modern Accent Chair for Dining Rooms and Offices, White ', 'По два се продаваат', 3000.00, 3, 1, ARRAY['/uploads/products/images-1752077720088-739770947.jpg', '/uploads/products/images-1752077720090-136112412.jpg', '/uploads/products/images-1752077720091-665653731.jpg'], 10, 'Skpje, Gazibaba', true, '2025-07-09T16:15:20.112Z', '2025-07-09T16:15:20.112Z');\nINSERT INTO products (id, title, description, price, category_id, seller_id, images, stock_quantity, location, is_active, created_at, updated_at) VALUES (5, 'Рачно направен сапун', '
    PREMIUM QUALITY: Traditional Cold Process Soap. Made by hand in Canada using 100% plant based and all natural ingredients. All natural aromas from premium essential oils and all natural colorants exclusively from minerals, clays and plant extracts.
    CLEAN & HEALTHY SKIN: Olive Oil, Coconut Oil, Shea Butter, Avocado Oil and Kaolin Clay leave your skin feeling nourished AND clean!
    NEVER SYNTHETIC: Our proprietary scents and colors are achieved exclusively from Premium Essential Oils and 100% Natural Clays, Minerals and Plant Extracts. NO phthalates, NO parabens, NO sulfates, NO silicones, NO micas or oxides, NO dyes.
    SUSTAINABLE AT OUR CORE: All ingredients are sourced sustainably and packaged in recycled kraft paperboard. Our products leave nothing but paper behind!
    THOUGHTFUL GIFT: Crate 61 Hand Made Traditional Bar Soaps make for a great gift! Choose from 15 scents and counting!
', 3000.00, 8, 1, ARRAY['/uploads/products/images-1752078337413-720452194.jpg', '/uploads/products/images-1752078337420-342447963.jpg', '/uploads/products/images-1752078337422-266048273.jpg'], 2, 'Bitola', true, '2025-07-09T16:25:37.440Z', '2025-07-09T16:25:37.440Z');\nINSERT INTO products (id, title, description, price, category_id, seller_id, images, stock_quantity, location, is_active, created_at, updated_at) VALUES (7, 'Сет лажички', '5 лажици', 700.00, 3, 2, ARRAY['/uploads/products/images-1752160993750-904970899.jpg', '/uploads/products/images-1752160993756-316550375.jpg'], 10, 'Скопје, Карпош', true, '2025-07-10T15:23:13.796Z', '2025-07-10T15:23:13.796Z');\n\n-- Reset sequences\nSELECT setval('users_id_seq', (SELECT MAX(id) FROM users));\nSELECT setval('categories_id_seq', (SELECT MAX(id) FROM categories));\nSELECT setval('products_id_seq', (SELECT MAX(id) FROM products));\n