#!/bin/bash
echo "🛑 Stopping all Kupi.mk servers..."

# Kill by port
echo "🔍 Killing processes on ports 3000, 5000, 5001, 5002..."
lsof -ti:3000 | xargs kill -9 2>/dev/null
lsof -ti:5000 | xargs kill -9 2>/dev/null
lsof -ti:5001 | xargs kill -9 2>/dev/null
lsof -ti:5002 | xargs kill -9 2>/dev/null

# Kill by process name
echo "🔍 Killing Node.js processes..."
pkill -f "npm run dev" 2>/dev/null
pkill -f "npm start" 2>/dev/null
pkill -f "react-scripts" 2>/dev/null
pkill -f "nodemon" 2>/dev/null

echo "✅ All servers stopped!"
