<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Validation\Rule;

class Batch extends Model
{
    use HasFactory, HasUuids;

    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'product_id',
        'batch_code',
        'production_date',
        'expiration_date',
        'net_weight',
        'gross_weight',
        'units_per_batch'
    ];

//    public static function getValidationRules($id = null): array
//    {
//        return [
//            'product_id' => 'required|string|exists:products,id',
//            'batch_code' => 'required|string|max:255|unique:batches,batch_code,' . $id,
//            'production_date' => 'required|date|before_or_equal:today',
//            'expiration_date' => 'required|date|after:production_date',
//            'net_weight' => 'required|numeric|min:0|max:999999.99',
//            'gross_weight' => 'required|numeric|min:0|max:999999.99|gte:net_weight',
//            'units_per_batch' => 'required|integer|min:1|max:1000000',
//        ];
//    }
    public static function getValidationRules($id = null): array
    {
        return [
            'product_id' => 'required|string|exists:products,id',
            'batch_code' => [
                'required',
                'string',
                'max:255',
                Rule::unique('batches')->ignore($id)
            ],
            'production_date' => 'required|date|before_or_equal:today',
            'expiration_date' => 'required|date|after:production_date',
            'net_weight' => 'required|numeric|min:0|max:999999.99',
            'gross_weight' => 'required|numeric|min:0|max:999999.99|gte:net_weight',
            'units_per_batch' => 'required|integer|min:1|max:1000000',
        ];
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function orders(): BelongsToMany
    {
        return $this->belongsToMany(Order::class, 'order_batches')
            ->withPivot('quantity', 'price_per_unit', 'total_price')
            ->withTimestamps();
    }
}
