<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Validation\Rule;

class Client extends Model
{
    use HasFactory, HasUuids;

    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'name',
        'country',
        'registration_number',
        'tax_code',
        'contact_person',
        'phone_number',
        'billing_address',
        'shipping_address',
    ];

//    public static function getValidationRules($id = null): array
//    {
//        return [
//            'name' => 'required|string|max:255|unique:clients,name,' . $id,
//            'country' => 'required|string|max:255',
//            'registration_number' => 'nullable|string|max:255|unique:clients,registration_number,' . $id,
//            'tax_code' => 'nullable|string|max:255|unique:clients,tax_code,' . $id,
//            'contact_person' => 'nullable|string|max:255',
//            'phone_number' => 'nullable|string|max:255|regex:/^[\+]?[0-9\s\-\(\)]+$/',
//            'billing_address' => 'nullable|string|max:1000',
//            'shipping_address' => 'nullable|string|max:1000',
//        ];
//    }

    public static function getValidationRules($id = null): array
    {
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('clients')->ignore($id),
            ],
            'country' => 'required|string|max:255',
            'registration_number' => [
                'nullable',
                'string',
                'max:255',
                Rule::unique('clients')->ignore($id),
            ],
            'tax_code' => [
                'nullable',
                'string',
                'max:255',
                Rule::unique('clients')->ignore($id),
            ],
            'contact_person' => 'nullable|string|max:255',
            'phone_number' => 'nullable|string|max:255|regex:/^[\+]?[0-9\s\-\(\)]+$/',
            'billing_address' => 'nullable|string|max:1000',
            'shipping_address' => 'nullable|string|max:1000',
        ];
    }

    // Orders where this company is the buyer
    public function buyerOrders(): HasMany
    {
        return $this->hasMany(Order::class, 'buyer_id');
    }

    // Orders where this company is the receiver
    public function receiverOrders(): HasMany
    {
        return $this->hasMany(Order::class, 'receiver_id');
    }
}
