<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Validation\Rule;

class PackingList extends Model
{
    use HasFactory, HasUuids;

    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'order_id',
        'packing_list_date',
        'status'
    ];

//    public static function getValidationRules($id = null): array
//    {
//        return [
//            'order_id' => 'required|string|exists:orders,id|unique:packing_lists,order_id,' . $id,
//            'packing_list_date' => 'required|date|before_or_equal:today',
//            'status' => 'required|string|in:draft,prepared,packed,shipped',
//        ];
//    }
    public static function getValidationRules($id = null): array
    {
        return [
            'order_id' => [
                'required',
                'string',
                'exists:orders,id',
                Rule::unique('packing_lists')->ignore($id)
            ],
            'packing_list_date' => 'required|date|before_or_equal:today',
            'status' => 'required|string|in:draft,prepared,packed,shipped',
        ];
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class, 'order_id');
    }
}
