<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Product extends Model
{
    use HasFactory, HasUuids;

    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';
    protected $fillable = [
        'name',
        'description',
        'hs_code',
        'price',
        'producer_id',
        'unit_of_measure',
    ];

    public static function getValidationRules($id = null): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'required|string|max:1000',
            'hs_code' => 'nullable|string|max:20|regex:/^[0-9.]+$/',
            'price' => 'required|numeric|min:0|max:999999.99',
            'producer_id' => 'required|string|exists:producers,id',
            'unit_of_measure' => 'required|string|max:50|in:vial, ampule, bottle, pack, scatula, carton'
        ];
    }

    protected $casts = [
        'price' => 'float',
    ];

    public function producer(): BelongsTo
    {
        return $this->belongsTo(Producer::class, 'producer_id');
    }

    //ne mi treba ova zasho ne ide direktno kroz orders tuku kroz batches
//    public function orders(): BelongsToMany
//    {
//        return $this->belongsToMany(Order::class, 'order_products', 'product_id', 'order_id');
//    }

    public function batches(): HasMany
    {
        return $this->hasMany(Batch::class);
    }
}
