<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIndexesToTables extends Migration
{
public function up(): void
{
Schema::table('users', function (Blueprint $table) {
$table->index('email', 'idx_users_email');
});

Schema::table('clients', function (Blueprint $table) {
$table->index(['name', 'country'], 'idx_clients_name_country');
});

Schema::table('batches', function (Blueprint $table) {
$table->index('batch_code', 'idx_batches_batch_code');
});

Schema::table('orders', function (Blueprint $table) {
$table->index('status', 'idx_orders_status');
});

Schema::table('payments', function (Blueprint $table) {
$table->index('payment_status', 'idx_payments_payment_status');
});
}

public function down(): void
{
Schema::table('users', function (Blueprint $table) {
$table->dropIndex('idx_users_email');
});

Schema::table('clients', function (Blueprint $table) {
$table->dropIndex('idx_clients_name_country');
});

Schema::table('batches', function (Blueprint $table) {
$table->dropIndex('idx_batches_batch_code');
});

Schema::table('orders', function (Blueprint $table) {
$table->dropIndex('idx_orders_status');
});

Schema::table('payments', function (Blueprint $table) {
$table->dropIndex('idx_payments_payment_status');
});
}
}
