<?php

namespace Database\Factories;

use App\Models\Payment;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Payment>
 */
class PaymentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = Payment::class;
    public function definition(): array
    {
        $paymentMethods = ['bank_transfer', 'credit_card', 'wire_transfer', 'check', 'cash'];
        $statuses = ['pending', 'completed', 'failed', 'refunded'];

        return [
            'invoice_id' => Invoice::factory(),
            'amount' => $this->faker->randomFloat(2, 500, 50000),
            'payment_date' => $this->faker->dateTimeBetween('-30 days', 'now'),
            'payment_method' => $this->faker->randomElement($paymentMethods),
            'status' => $this->faker->randomElement($statuses),
            'transaction_reference' => $this->faker->regexify('TXN[0-9]{10}'),
        ];
    }

    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'completed',
        ]);
    }

    public function bankTransfer(): static
    {
        return $this->state(fn (array $attributes) => [
            'payment_method' => 'bank_transfer',
            'transaction_reference' => $this->faker->regexify('BT[0-9]{12}'),
        ]);
    }

    public function wireTransfer(): static
    {
        return $this->state(fn (array $attributes) => [
            'payment_method' => 'wire_transfer',
            'transaction_reference' => $this->faker->regexify('WT[0-9]{12}'),
        ]);
    }
}
