<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Transport>
 */
class TransportFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    protected $model = Transport::class;
    public function definition(): array
    {
        $transportCompanies = [
            'DHL Express', 'FedEx International', 'UPS Global', 'TNT Express',
            'Maersk Logistics', 'DB Schenker', 'Kuehne + Nagel', 'DSV Panalpina',
            'Expeditors International', 'CEVA Logistics'
        ];

        $transportMethods = ['air', 'sea', 'road', 'rail'];

        return [
            'company_name' => $this->faker->randomElement($transportCompanies),
            'method' => $this->faker->randomElement($transportMethods),
            'cost' => $this->faker->randomFloat(2, 1, 5000),
            'tracking_number' => $this->faker->regexify('[A-Z]{2}[0-9]{10}[A-Z]{2}'),
        ];
    }
    public function airTransport(): static
    {
        return $this->state(fn (array $attributes) => [
            'method' => 'air',
            'cost' => $this->faker->randomFloat(2, 1, 5000),
        ]);
    }
    public function seaTransport(): static
    {
        return $this->state(fn (array $attributes) => [
            'method' => 'sea',
            'cost' => $this->faker->randomFloat(2, 1, 1500),
        ]);
    }
}
