<?php

namespace Database\Factories;

use App\Models\Batch;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;

class BatchFactory extends Factory
{
    protected $model = Batch::class;

    public function definition(): array
    {
        $product = Product::query()->exists()
            ? Product::query()->inRandomOrder()->first()
            : Product::factory()->create();

        $createdAt = $this->faker->dateTimeBetween('-6 months', 'now');

        return [
            'product_id' => $product->id,
            'batch_code' => strtoupper($this->faker->bothify('BATCH-#####')),
            'production_date' => $createdAt,
            'expiration_date' => $this->faker->dateTimeBetween($createdAt, '+1 year'),
            'gross_weight' => $this->faker->randomFloat(2, 100, 1000),
            'net_weight' => $this->faker->randomFloat(2, 80, 950),
            'units_per_batch' => 100000,
        ];
    }
}
