<?php

namespace Database\Seeders;

use App\Models\Batch;
use App\Models\Product;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class BatchSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $products = Product::all();

        foreach ($products as $product) {
            for ($i = 0; $i <= 3; $i++) {
                Batch::create([
                    'id' => Str::uuid(),
                    'product_id' => $product->id,
                    'batch_code' => 'BATCH-' . strtoupper(Str::random(6)),
                    'production_date' => now()->subDays(rand(10, 100)),
                    'expiration_date' => now()->addMonths(rand(6, 18)),
                    'net_weight' => 1.5,
                    'gross_weight' => 1.7,
                    'units_per_batch' => 100000,
                ]);
            }
        }
    }
}
