export interface Column {
    key: string
    label: string
    sortable?: boolean
    formatter?: (value: any, row: any) => string
    component?: string // For future custom cell components
}

export interface ExpandedField {
    key: string
    label: string
    formatter?: (value: any, row: any) => string
    span?: 1 | 2 // Grid span (1 = half width, 2 = full width)
}

export interface ExpandedSection {
    title: string
    fields: ExpandedField[]
}

export interface CrudConfig {
    title: string
    endpoint: string // e.g., '/clients', '/orders', '/transports'
    searchPlaceholder: string
    columns: Column[]
    expandedSections?: ExpandedSection[]
    searchFields?: string[] // Backend search fields (optional)
}

export interface PaginatedData<T = any> {
    data: T[]
    current_page: number
    last_page: number
    per_page: number
    total: number
    from: number
    to: number
    links?: Array<{
        url: string | null
        label: string
        active: boolean
    }>
}

export interface CrudFilters {
    search?: string
    sort_by: string
    sort_direction: 'asc' | 'desc'
    per_page: number
}

export interface FormField {
    key: string
    label: string
    type: 'text' | 'textarea' | 'email' | 'tel' | 'number' | 'date'
    required?: boolean
    placeholder?: string
    span?: 1 | 2 // Grid span for layout
}

export interface ActionButton {
    label: string
    variant: 'default' | 'outline' | 'destructive' | 'ghost'
    action: (row: any) => void
    condition?: (row: any) => boolean // Show button conditionally
}

export interface Column {
    key: string
    label: string
    sortable?: boolean
    formatter?: (value: any, row: any) => string
    component?: string // For future custom cell components
}

export interface ExpandedField {
    key: string
    label: string
    formatter?: (value: any, row: any) => string
    span?: 1 | 2 // Grid span (1 = half width, 2 = full width)
}

export interface ExpandedSection {
    title: string
    fields: ExpandedField[]
}

export interface CrudConfig {
    title: string
    endpoint: string // e.g., '/clients', '/orders', '/transports'
    searchPlaceholder: string
    columns: Column[]
    expandedSections?: ExpandedSection[]
    searchFields?: string[] // Backend search fields (optional)
    formFields: FormField[] // Fields for create/edit forms
    customActions?: ActionButton[] // Custom action buttons per row
    canCreate?: boolean
    canEdit?: boolean
    canDelete?: boolean
    deleteConfirmMessage?: (row: any) => string
}

export interface PaginatedData<T = any> {
    data: T[]
    current_page: number
    last_page: number
    per_page: number
    total: number
    from: number
    to: number
    links?: Array<{
        url: string | null
        label: string
        active: boolean
    }>
}

export interface CrudFilters {
    search?: string
    sort_by: string
    sort_direction: 'asc' | 'desc'
    per_page: number
}
