<?php

namespace App\Traits;

use Illuminate\Support\Facades\Schema;

trait CrudTrait
{
    public static function getCrudFields(): array
    {
        $table = (new static)->getTable();
        $columns = Schema::getColumnListing($table);

        // You can filter out unwanted columns like timestamps, id, etc.
        return array_values(array_diff($columns, ['id', 'created_at', 'updated_at', 'deleted_at']));
    }
}
