<?php

namespace Database\Seeders;

use App\Models\Producer;
use App\Models\Product;
use Illuminate\Database\Seeder;

class ProducerAndProductSeeder extends Seeder
{
    public function run(): void
    {
        // Ensure there’s exactly one producer
        $producer = Producer::first() ?? Producer::create([
            'name' => 'Pharma Export',
            'address' => '11a Street, Industrial Zone',
            'country' => 'Macedonia',
            'phone_number' => '+389 70 000 000',
            'email' => 'contact@pharmaexport.com',
        ]);

        Product::factory()
            ->count(15)
            ->state([
                'producer_id' => $producer->id
            ])
            ->create();
    }
}
