<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Route;

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'login'])->name('login');
    Route::post('/login', [AuthController::class, 'storeLogin'])->name('storeLogin');
});
Route::middleware('auth')->group(function () {
    Route::redirect('/', '/dashboard');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::get('/products', [ProductController::class, 'products'])->name('products');
    Route::get('/orders', [OrderController::class, 'orders'])->name('orders');
    Route::get('/clients', [ClientController::class, 'index'])->name('clients');
    //Route::get('/transports', [TransportController::class, 'transports'])->name('transports');
});
