<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice {{ $invoiceNumber }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            color: #333;
            line-height: 1.5;
        }
        .header {
            margin-bottom: 30px;
            border-bottom: 3px solid #2563eb;
            padding-bottom: 20px;
        }
        .header h1 {
            font-size: 32px;
            color: #2563eb;
            margin-bottom: 5px;
        }
        .header .invoice-details {
            text-align: right;
            font-size: 11px;
        }
        .company-info {
            margin-bottom: 10px;
        }
        .company-info h2 {
            font-size: 16px;
            margin-bottom: 5px;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            color: #2563eb;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #e5e7eb;
        }
        .two-column {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        .column {
            display: table-cell;
            width: 48%;
            vertical-align: top;
        }
        .column:first-child {
            padding-right: 4%;
        }
        .info-box {
            background: #f9fafb;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 10px;
        }
        .info-box p {
            margin-bottom: 3px;
        }
        .info-box strong {
            display: inline-block;
            min-width: 100px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table thead {
            background: #2563eb;
            color: white;
        }
        table th {
            padding: 10px;
            text-align: left;
            font-weight: bold;
            font-size: 11px;
        }
        table td {
            padding: 8px 10px;
            border-bottom: 1px solid #e5e7eb;
        }
        table tbody tr:hover {
            background: #f9fafb;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .totals-section {
            margin-top: 20px;
            float: right;
            width: 300px;
        }
        .totals-row {
            display: table;
            width: 100%;
            padding: 8px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        .totals-row.total {
            background: #2563eb;
            color: white;
            font-size: 16px;
            font-weight: bold;
            padding: 12px 10px;
            margin-top: 5px;
            border-radius: 5px;
        }
        .totals-label {
            display: table-cell;
            width: 60%;
            font-weight: bold;
        }
        .totals-amount {
            display: table-cell;
            width: 40%;
            text-align: right;
        }
        .notes {
            clear: both;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 2px solid #e5e7eb;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
        }
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: bold;
        }
        .status-pending { background: #fef3c7; color: #92400e; }
        .status-paid { background: #d1fae5; color: #065f46; }
        .status-overdue { background: #fee2e2; color: #991b1b; }
    </style>
</head>
<body>
<div class="header">
    <div style="display: table; width: 100%;">
        <div style="display: table-cell; width: 50%;">
            <div class="company-info">
                <h2>Your Company Name</h2>
                <p>123 Business Street</p>
                <p>Skopje, North Macedonia</p>
                <p>Email: info@company.com</p>
                <p>Phone: +389 XX XXX XXX</p>
            </div>
        </div>
        <div style="display: table-cell; width: 50%; text-align: right;">
            <h1>INVOICE</h1>
            <div class="invoice-details">
                <p><strong>Invoice #:</strong> {{ $invoiceNumber }}</p>
                <p><strong>Date:</strong> {{ $invoiceDate }}</p>
                <p><strong>Due Date:</strong> {{ $dueDate }}</p>
                <p><strong>Order ID:</strong> {{ $order->id }}</p>
            </div>
        </div>
    </div>
</div>

<div class="two-column">
    <div class="column">
        <div class="section-title">Bill To</div>
        <div class="info-box">
            <p><strong>{{ $order->buyer->name }}</strong></p>
            <p>{{ $order->buyer->address ?? 'N/A' }}</p>
            <p>{{ $order->buyer->city ?? '' }}, {{ $order->buyer->country ?? '' }}</p>
            <p>Email: {{ $order->buyer->email ?? 'N/A' }}</p>
            <p>Phone: {{ $order->buyer->phone ?? 'N/A' }}</p>
        </div>
    </div>
    <div class="column">
        <div class="section-title">Ship To</div>
        <div class="info-box">
            <p><strong>{{ $order->receiver->name }}</strong></p>
            <p>{{ $order->receiver->address ?? 'N/A' }}</p>
            <p>{{ $order->receiver->city ?? '' }}, {{ $order->receiver->country ?? '' }}</p>
            <p>Email: {{ $order->receiver->email ?? 'N/A' }}</p>
            <p>Phone: {{ $order->receiver->phone ?? 'N/A' }}</p>
        </div>
    </div>
</div>

<div class="section">
    <div class="section-title">Order Details</div>
    <table>
        <thead>
        <tr>
            <th>#</th>
            <th>Batch Code</th>
            <th>Product</th>
            <th class="text-center">Quantity</th>
            <th class="text-right">Unit Price</th>
            <th class="text-right">Total</th>
        </tr>
        </thead>
        <tbody>
        @foreach($order->batches as $index => $batch)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $batch->batch_code }}</td>
                <td>{{ $batch->product->name ?? 'N/A' }}</td>
                <td class="text-center">{{ $batch->pivot->quantity }}</td>
                <td class="text-right">{{ $currency }} {{ number_format($batch->pivot->price_per_unit, 2) }}</td>
                <td class="text-right">{{ $currency }} {{ number_format($batch->pivot->total_price, 2) }}</td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div>

<div class="totals-section">
    <div class="totals-row">
        <div class="totals-label">Subtotal:</div>
        <div class="totals-amount">{{ $currency }} {{ $subtotal }}</div>
    </div>
    <div class="totals-row">
        <div class="totals-label">Tax ({{ $taxRate }}%):</div>
        <div class="totals-amount">{{ $currency }} {{ $taxAmount }}</div>
    </div>
    <div class="totals-row total">
        <div class="totals-label">Total Amount:</div>
        <div class="totals-amount">{{ $currency }} {{ $totalAmount }}</div>
    </div>
</div>

<div class="notes">
    @if($order->payment)
        <div class="section-title">Payment Information</div>
        <div class="info-box">
            <p><strong>Status:</strong>
                <span class="status-badge status-{{ $order->payment->payment_status }}">
                    {{ strtoupper($order->payment->payment_status) }}
                </span>
            </p>
            <p><strong>Payment Method:</strong> {{ ucwords(str_replace('_', ' ', $order->payment->payment_method)) }}</p>
            <p><strong>Due Date:</strong> {{ \Carbon\Carbon::parse($order->payment->due_date)->format('Y-m-d') }}</p>
            @if($order->payment->payment_date)
                <p><strong>Payment Date:</strong> {{ \Carbon\Carbon::parse($order->payment->payment_date)->format('Y-m-d') }}</p>
            @endif
        </div>
    @endif

    <div class="section-title" style="margin-top: 20px;">Payment Instructions</div>
    <p>Please make payment to:</p>
    <p><strong>Bank Name:</strong> Your Bank Name</p>
    <p><strong>Account Number:</strong> XXXX-XXXX-XXXX</p>
    <p><strong>SWIFT/BIC:</strong> XXXXXXXX</p>
    <p><strong>Reference:</strong> {{ $invoiceNumber }}</p>
</div>

<div class="footer">
    <p>Thank you for your business!</p>
    <p>This is a computer-generated invoice. For any queries, please contact us at info@company.com</p>
</div>
</body>
</html>
