<?php

use App\Http\Controllers\OrderController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\GenericModelController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AuthController;
use Illuminate\Http\Request;

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'login'])->name('login');
    Route::post('/login', [AuthController::class, 'storeLogin'])->name('storeLogin');
});

Route::middleware('auth')->group(function () {
    Route::redirect('/', '/dashboard');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    // Users routes with admin middleware
    Route::prefix('users')->middleware('admin')->group(function () {
        Route::get('/', function (Request $request) {
            return app(GenericModelController::class)->index($request, 'users');
        })->name('users.index');

        Route::post('/', function (Request $request) {
            return app(GenericModelController::class)->store($request, 'users');
        })->name('users.store');

        Route::put('/{id}', function (Request $request, $id) {
            return app(GenericModelController::class)->update($request, 'users', $id);
        })->name('users.update');

        Route::delete('/{id}', function (Request $request, $id) {
            return app(GenericModelController::class)->destroy('users', $id);
        })->name('users.destroy');
    });

    // Order-specific routes (MUST come BEFORE generic routes)
    Route::prefix('orders')->group(function () {
        // Batch operations for select options (no order parameter) - MUST BE FIRST
        Route::get('batches/select-options', [OrderController::class, 'getBatchesForSelect'])
            ->name('orders.batches.select-options');

        // CRUD operations for orders
        Route::get('/', [OrderController::class, 'index'])->name('orders.index');
        Route::post('/', [OrderController::class, 'store'])->name('orders.store');

        // Order-specific operations (with order parameter)
        Route::post('{order}/create-payment', [OrderController::class, 'createPayment'])
            ->name('orders.create-payment');

        Route::post('{order}/add-batch', [OrderController::class, 'addBatch'])
            ->name('orders.add-batch');

        Route::delete('{order}/remove-batch/{batch}', [OrderController::class, 'removeBatch'])
            ->name('orders.remove-batch');

        Route::get('{order}/available-batches', [OrderController::class, 'getAvailableBatches'])
            ->name('orders.available-batches');

        // PDF generation routes
        Route::get('{order}/generate-invoice', [OrderController::class, 'generateInvoice'])
            ->name('orders.generate-invoice');

        Route::get('{order}/generate-packing-list', [OrderController::class, 'generatePackingList'])
            ->name('orders.generate-packing-list');

        // Preview routes (GET)
        Route::get('{order}/preview-invoice', [OrderController::class, 'previewInvoice'])
            ->name('orders.preview-invoice');

        Route::get('{order}/preview-packing-list', [OrderController::class, 'previewPackingList'])
            ->name('orders.preview-packing-list');
        // Update and Delete (must come after specific routes to avoid conflicts)
        Route::put('{order}', [OrderController::class, 'update'])->name('orders.update');
        Route::delete('{order}', [OrderController::class, 'destroy'])->name('orders.destroy');
    });

    // Generic model routes (MUST come LAST as catch-all)
    Route::prefix('{model}')->group(function () {
        Route::get('/', [GenericModelController::class, 'index'])->name('generic.index');
        Route::post('/', [GenericModelController::class, 'store'])->name('generic.store');
        Route::put('/{id}', [GenericModelController::class, 'update'])->name('generic.update');
        Route::delete('/{id}', [GenericModelController::class, 'destroy'])->name('generic.destroy');
    });
});
