import { ref } from 'vue'

// Create the ref OUTSIDE the function so it's shared across all calls
const savedTheme = localStorage.getItem('theme') || 'light'
const theme = ref(savedTheme)

function useTheme() {
    console.log('useTheme function called')

    const setTheme = (newTheme: string) => {
        console.log('setTheme function called with:', newTheme)
        theme.value = newTheme

        // Handle system theme
        if (newTheme === 'system') {
            const systemPrefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches
            if (systemPrefersDark) {
                document.documentElement.classList.add('dark')
            } else {
                document.documentElement.classList.remove('dark')
            }
        } else if (newTheme === 'dark') {
            document.documentElement.classList.add('dark')
        } else {
            document.documentElement.classList.remove('dark')
        }

        localStorage.setItem('theme', newTheme)
    }

    // Initialize theme on load (but only once)
    if (!theme.value) {
        setTheme(savedTheme)
    } else {
        // Reapply the current theme
        setTheme(theme.value)
    }

    return {
        theme,
        setTheme
    }
}

export default useTheme
