import {clsx, ClassValue} from 'clsx'
import {twMerge} from 'tailwind-merge'

export function cn(...inputs: ClassValue[]) {
    return twMerge(clsx(inputs))
}

export function toCamelCase(str: string): string {
    return str.replace(/([-_]\w)/g, (g) => g[1].toUpperCase());
}

export function formatLabel(str: string): string {
    // Replace underscores with spaces and capitalize the first letter of each word
    const words = str.replace(/_/g, ' ').split(' ');
    const formattedWords = words.map((word) => {
        return word.charAt(0).toUpperCase() + word.slice(1);
    });
    return formattedWords.join(' ');
}
