<?php

namespace Database\Factories;

use App\Models\Buyer;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Buyer>
 */
class BuyerFactory extends Factory
{
    protected $model = Buyer::class;
    public function definition(): array
    {
        return [
            'company_name' => $this->faker->company(),
            'billing_address' => $this->faker->address(),
            'country' => $this->faker->country(),
            'registration_number' => $this->faker->regexify('[A-Z]{2}[0-9]{8}'),
            'tax_id' => $this->faker->regexify('TAX[0-9]{10}')
        ];
    }
}
